%function [x_axis,y_axis,z_axis] = get_IV
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the 1st file you want to analyze'))
[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
file = importdata(fullfile(pathName,fileName));

%% ask for the current
prompt_current = 'enter the current module amplification';
dlgtitle_current = 'Input';
user_val_current = inputdlg(prompt_current,dlgtitle_current);
current_val = str2num(user_val_current{1});

%% ask for the voltage
prompt_voltage = 'enter the Vmeasure module amplification';
dlgtitle_voltage = 'Input';
user_val_voltage = inputdlg(prompt_voltage,dlgtitle_voltage);
voltage_val = str2num(user_val_voltage{1});

%% Reading the size of Ibias
str_Ibias = char(file.textdata(6));
str_split = strsplit(str_Ibias);
size_Ibias = str2num(str_split{3});

%% Getting Ibias values
Ibias = file.data(1:size_Ibias,1)*current_val;

%% Getting Vmeasure
Vmeas = file.data(1:size_Ibias,4)*voltage_val;

%% ask the user to load the 2nd file
uiwait(msgbox('Choose the 2nd file you want to analyze'))
[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
file = importdata(fullfile(pathName,fileName));

%% ask for the current
prompt_current = 'enter the current module amplification';
dlgtitle_current = 'Input';
user_val_current = inputdlg(prompt_current,dlgtitle_current);
current_val = str2num(user_val_current{1});

%% ask for the voltage
prompt_voltage = 'enter the Vmeasure module amplification';
dlgtitle_voltage = 'Input';
user_val_voltage = inputdlg(prompt_voltage,dlgtitle_voltage);
voltage_val = str2num(user_val_voltage{1});

%% Getting Ibias values
Ibias1 = file.data(1:size_Ibias,1)*current_val;

%% Getting Vmeasure
Vmeas1 = file.data(1:size_Ibias,4)*voltage_val;



Vsub = Ibias*250*10^6; %R(Ibias = 0) = 250 ohms, subtracting resistance at zero bias from all data points
Vsub1 = Ibias1*250*10^6; %R(Ibias = 0) = 250 ohms, subtracting resistance at zero bias from all data points

plot(Ibias*10^9,Vmeas*10^6-Vsub)
hold on
plot(Ibias1*10^9,Vmeas1*10^6-Vsub1)
ylabel('$V(\mu V)$','Interpreter','latex')
xlabel('$I_{bias}(nA)$','Interpreter','latex');

%end